<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $elemento       = $geecomDb->leggiSingolaRiga("geec_slideMetro",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_metroSlider",$elemento["idSlider"]);
    }
    
    $arrayTipiSlide = array("ultimiArticoli"=>"Ultimi articoli inseriti","categorie"=>"Ultimi articoli delle categorie indicate","contenuti"=>"Contenuti specifici");
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione elemento</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==220) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Slide duplicata, modificala per non avere due slide uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        
                        <div class="col-12">
                            <div class="card mb-4 box-shadow-lite">
                                <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                    
                                    <input type="text" class="d-none" name="operazione" value="modificaElemento">
                                    <input type="text" class="d-none" name="id" value="<?php echo((isset($elemento) ? $elemento["idSlider"] : "0")); ?>">
                                    <input type="text" class="d-none" name="idElemento" value="<?php echo((isset($elemento) ? $elemento["id"] : "0")); ?>">

                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-12 col-lg-6 d-md-flex">
                                                <h6 class="mt-2 mr-2 text-nowrap">Slide:</h6>
                                                <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome elemento" value="<?php echo((isset($elemento) ? $elemento["nome"] : "")) ?>" placeholder="Nome occorrenza">
                                            </div>
                                            <div class="col text-right">
                                                <a class="btn btn-outline-primary mt-2 mt-lg-0" href="creaMetro.php?id=<?php echo (isset($elemento) ? $elemento["idSlider"] : "") ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                                <button class="btn btn-primary mt-2 mt-lg-0" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                                <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=<?php echo((isset($elemento) ? $elemento["idSlider"] : "")) ?>&amp;operazione=duplicaElemento&idElemento=<?php echo((isset($elemento) ? $elemento["id"] : "")) ?>';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="form-group col-md-4">
                                                <label for="titolo-articolo">Tipo</label>
                                                <select class="form-control" id="tipoSlide" name="tipo" onchange="mostraCampi('<?php echo $elemento["tipo"] ?>')">
                                                <?php 
                                                    foreach($arrayTipiSlide as $tipo=>$etichetta) {
                                                        if(isset($elemento) && $elemento["tipo"]==$tipo) {
                                                            echo"<option value=\"$tipo\" selected>$etichetta</option>";
                                                        }
                                                        else {                                                               
                                                            echo"<option value=\"$tipo\">$etichetta</option>";
                                                        }
                                                    }
                                                ?> 
                                                </select>
                                            </div>

                                            <div id="divLinguaContenuti" class="<?php echo(($elemento["tipo"]=="ultimiArticoli") ? "form-group col-md-4" : "d-none") ?>">
                                                <label for="titolo-articolo">Lingua contenuti</label>
                                                <select class="form-control" name="linguaContenuti">
                                                <?php 
                                                    foreach($lingue as $lingua) {
                                                        if(isset($elemento) && $elemento["linguaContenuti"]==$lingua) {
                                                            echo"<option value=\"$lingua\" selected>$lingua</option>";
                                                        }
                                                        else {                                                               
                                                            echo"<option value=\"$lingua\">$lingua</option>";
                                                        }
                                                    }
                                                ?> 
                                                </select>
                                            </div>

                                            <?php 
                                                $contenutiSelezionati = explode(",",$elemento["contenuti"]);
                                                
                                                if($elemento["tipo"]=="contenuti") {
                                            ?>
                                                <div class="w-100"></div>
                                                <div id="divSelezionaContenuti" class="col-12">
                                                    <div class="row">
                                                        <?php 
                                                            for($i=0;$i<$datiOccorrenza["articoliPerSlide"];$i++) {
                                                        ?>
                                                                <div class="form-group col-lg-4">
                                                                    <label for="sottotitolo-articolo">Contenuto in posizione <?php echo $i+1 ?></label>
                                                                    <select class="selectpicker" data-live-search="true" data-size="5" data-width="100%" name="contenuto<?php echo $i ?>" >
                                                                        <?php
                                                                            $queryNomiTag = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo'";
                                                                            $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                            while($tag = $risNomi->fetch_assoc()) {
                                                                                if($contenutiSelezionati[$i] == $tag["id"]) {
                                                                                    echo"<option value=\"{$tag["id"]}\" selected>{$tag["titolo"]}</option>";						
                                                                                }
                                                                                else {
                                                                                    echo"<option value=\"{$tag["id"]}\">{$tag["titolo"]}</option>";
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                        <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                            <?php
                                                }
                                                else if($elemento["tipo"]=="categorie") {
                                            ?>
                                                <div class="w-100"></div>
                                                <div id="divSelezionaContenuti" class="col-12">
                                                    <div class="row">
                                                        
                                                        <?php 
                                                            for($i=0;$i<$datiOccorrenza["articoliPerSlide"];$i++) {
                                                        ?>
                                                                <div class="form-group col-lg-4">
                                                                    <label for="sottotitolo-articolo">Categoria in posizione <?php echo $i+1 ?></label>
                                                                    <select class="selectpicker" data-live-search="true" data-size="5" data-width="100%" name="contenuto<?php echo $i ?>" >
                                                                        <?php
                                                                            $contenutiSelezionati = explode(",",$elemento["contenuti"]);
                                                                            $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre=0 ORDER BY posizione ASC";
                                                                            $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                            while($categoria = $risNomi->fetch_assoc()) {
                                                                                if($contenutiSelezionati[$i] == $categoria["id"]) {
                                                                                    echo"<option value=\"{$categoria["id"]}\" selected>{$categoria["nome"]}</option>";						
                                                                                }
                                                                                else {
                                                                                    echo"<option value=\"{$categoria["id"]}\">{$categoria["nome"]}</option>";
                                                                                }
                                                                                
                                                                                // cerco e stampo eventuali sottocategorie
                                                                                $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                                                                                $risSottoCategorie   = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                                                while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                                                                                    if($contenutiSelezionati[$i] == $sottoCategoria["id"]) {
                                                                                        echo"<option value=\"{$sottoCategoria["id"]}\" selected> - {$sottoCategoria["nome"]}</option>";						
                                                                                    }
                                                                                    else {
                                                                                        echo"<option value=\"{$sottoCategoria["id"]}\"> - {$sottoCategoria["nome"]}</option>";
                                                                                    }
                                                                                    
                                                                                    // cerco e stampo eventuali sottocategorie della sottocategoria
                                                                                    $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                                                                                    $risSottoCategorieSottoCategorie= $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                                                    while($sottoCategoriaDellaSottoCategoria = $risSottoCategorieSottoCategorie->fetch_assoc()) {
                                                                                        if($contenutiSelezionati[$i] == $sottoCategoriaDellaSottoCategoria["id"]) {
                                                                                            echo"<option value=\"{$sottoCategoriaDellaSottoCategoria["id"]}\" selected> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</option>";						
                                                                                        }
                                                                                        else {
                                                                                            echo"<option value=\"{$sottoCategoriaDellaSottoCategoria["id"]}\"> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</option>";
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                        <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                            <?php
                                                }
                                            ?>
                                        </form>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                </div>
                            </div>
                        
                            </div>
                        </div>
           
                    </form>

                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagineElemento",
                    idElemento:<?php echo $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function mostraCampi(valoreIniziale) {
                var tipoSlide             = document.getElementById("tipoSlide").value;
                if(tipoSlide==valoreIniziale) {
                    document.getElementById("divSelezionaContenuti").className = "col-12";
                }
                else if(tipoSlide=="ultimiArticoli") {
                    document.getElementById("divLinguaContenuti").className    = "form-group col-md-4";
                    document.getElementById("divSelezionaContenuti").className = "d-none";
                }
                else {
                    document.formComponente.submit();
                }
            }
        </script>

    </body>
</html>